/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.permission;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.permission.handler.IPermissionHandler;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.magmafoundation.magma.Magma;

public final class MagmaPermissionHandler
implements IPermissionHandler {
    private final IPermissionHandler delegate;

    public MagmaPermissionHandler(IPermissionHandler delegate) {
        Objects.requireNonNull(delegate, "permission handler");
        this.delegate = delegate;
    }

    @Override
    public ResourceLocation getIdentifier() {
        return new ResourceLocation(Magma.getName().toLowerCase(Locale.ROOT), "permission");
    }

    @Override
    public Set<PermissionNode<?>> getRegisteredNodes() {
        return this.delegate.getRegisteredNodes();
    }

    @Override
    public <T> T getPermission(ServerPlayer player, PermissionNode<T> node, PermissionDynamicContext<?> ... context) {
        if (node.getType() == PermissionTypes.BOOLEAN) {
            return (T)Boolean.valueOf(player.getBukkitEntity().hasPermission(node.getNodeName()));
        }
        return this.delegate.getPermission(player, node, context);
    }

    @Override
    public <T> T getOfflinePermission(UUID uuid, PermissionNode<T> node, PermissionDynamicContext<?> ... context) {
        Player player = Bukkit.getPlayer(uuid);
        if (player != null && node.getType() == PermissionTypes.BOOLEAN) {
            return (T)Boolean.valueOf(player.hasPermission(node.getNodeName()));
        }
        return this.delegate.getOfflinePermission(uuid, node, context);
    }
}

